function [resid, TD_, zeta_f_TD] = full_transition_inv_tech_progress(TD_guess, endo_0, endo_T, param, zeta_f_0, rho_zeta)
% This function takes an initial guess (Tx5) and computes the full
% transition path and the (Tx5) residual equations.


TD_guess = reshape(TD_guess,length(TD_guess)/5 ,5);
theta_n = TD_guess(:, 1);   % theta_n_t+1
theta_o = TD_guess(:, 2);   % theta_o_t+1
theta_f = TD_guess(:, 3);   % theta_f_t
p       = TD_guess(:, 4);   % p_t
phi_RC  = TD_guess(:, 5);   % phi_RC_t

phi_o_0 = theta_o(end);
theta_o(end) = endo_T.theta_o;

T = length(theta_n);

% G_f_TD = zeta_f_TD * G_f_TD.^(1-xi)
zeta_f_TD = ((1-rho_zeta.^(1:T)) + rho_zeta.^(1:T)*zeta_f_0)';
zeta_f_TD = zeta_f_TD.^(1-param.xi);

resid = zeros(T, 5);

p_p         = [p(2:end); endo_T.p];

theta_n_L   = [endo_0.theta_n; theta_n(1:end-1)]; % This is theta_t

mu_1_n      = p - param.eta * param.psi * theta_n_L.^(param.eta-1);
mu_1_n_p    = [mu_1_n(2:end); endo_T.mu_1_n];

beta_til_p  = mu_1_n ./ (p_p .* theta_n + (1-theta_n).*mu_1_n_p - param.psi * theta_n.^(param.eta));


mu_2_n      = zeros(T, 1);
mu_2_n_p    = zeros(T, 1);
mu_2_n_p(end) = endo_T.mu_2_n;

for t = T:-1:1
    mu_2_n(t) = param.lambda * mu_1_n(t) + (1-param.lambda) * beta_til_p(t) * mu_2_n_p(t);
    if t>1
        mu_2_n_p(t-1) = mu_2_n(t);
    end
end
    
I_n         = (param.xi * param.G_n^(1-param.xi) * mu_2_n).^(1/(1-param.xi));

X_n         = zeros(T, 1); % Effectively this is X_t+1 it is just chosen at t
F_n         = zeros(T, 1); % Effectively this is F_t+1 it is just chosen at t

for t = 1:T
    if t==1
        X_n(t) = (1-param.lambda)*endo_0.X_n + I_n(t)^(param.xi) * param.G_n^(1-param.xi);
        F_n(t) = (1-endo_0.theta_n)* endo_0.F_n + param.lambda * X_n(t);
    else
        X_n(t) = (1-param.lambda)*X_n(t-1) + I_n(t)^(param.xi) * param.G_n^(1-param.xi);
        F_n(t) = (1-theta_n(t-1))* F_n(t-1) + param.lambda * X_n(t);
    end
end


mu_1_f      = p - param.eta_f * param.psi_f * theta_f.^(param.eta_f-1);
mu_1_f_p    = [mu_1_f(2:end); endo_T.mu_1_f];
theta_f_p   = [theta_f(2:end); endo_T.theta_f];

resid(:, 1) = mu_1_f - beta_til_p .* (p_p.*theta_f_p + (1-theta_f_p) .* mu_1_f_p ...
    - param.psi_f * theta_f_p.^(param.eta_f));

mu_2_f = zeros(T,1);
for t = T:-1:1
    if t==T
        mu_2_f(t) = param.lambda_f * mu_1_f(t) + (1-param.lambda_f) * beta_til_p(t) * endo_T.mu_2_f;
    else
        mu_2_f(t) = param.lambda_f * mu_1_f(t) + (1-param.lambda_f) * beta_til_p(t) *  mu_2_f(t+1);        
    end
end

I_f     = (param.xi * param.G_f^(1-param.xi) * zeta_f_TD .* mu_2_f).^(1/(1-param.xi));


X_f         = zeros(T, 1); % Effectively this is X_t+1 it is just chosen at t
F_f         = zeros(T, 1); % Effectively this is F_t+1 it is just chosen at t

for t = 1:T
    if t==1
        X_f(t) = (1-param.lambda_f)*endo_0.X_f + I_f(t)^(param.xi) * zeta_f_TD(t) * param.G_f^(1-param.xi);
        F_f(t) = (1-theta_f(t))* endo_0.F_f + param.lambda_f * X_f(t);
    else
        X_f(t) = (1-param.lambda_f)*X_f(t-1) + I_f(t)^(param.xi) * zeta_f_TD(t) * param.G_f^(1-param.xi);
        F_f(t) = (1-theta_f(t))* F_f(t-1) + param.lambda_f * X_f(t);
    end
end


mu_1_o          = zeros(T, 1);
mu_1_o_p        = zeros(T, 1);
mu_1_o_p(end)   = endo_T.mu_1_o;

phi_RC_p        = [phi_RC(2:end); endo_T.phis.RC];

for t = T:-1:1
    mu_1_o(t)   = beta_til_p(t) * ...
        (mu_1_o_p(t)+(param.eta-1)*param.psi*theta_o(t)^param.eta ...
         -(param.eta-1)*param.psi*theta_o(t)^(param.eta)*phi_RC_p(t));
     if t>1
         mu_1_o_p(t-1) = mu_1_o(t);
     end
end

phi_o_p         = p_p - mu_1_o_p - param.eta*param.psi*(theta_o).^(param.eta-1).*(1-phi_RC_p);
phi_o           = [phi_o_0; phi_o_p(1:end-1)];

mu_2_o          = zeros(T, 1);
mu_2_o_p        = [zeros(T-1,1); endo_T.mu_2_o];

for t = T:-1:1
    mu_2_o(t)    = param.lambda * mu_1_o(t) + beta_til_p(t) * (1-param.lambda) * mu_2_o_p(t);
    if t>1
        mu_2_o_p(t-1) = mu_2_o(t);
    end
end


I_o     = (param.xi * param.G_o^(1-param.xi) * mu_2_o./(1-phi_RC)).^(1/(1-param.xi));

X_o         = zeros(T, 1); % Effectively this is X_t+1 it is just chosen at t
F_o         = zeros(T, 1); % Effectively this is F_t+1 it is just chosen at t

for t = 1:T
    if t==1
        X_o(t) = (1-param.lambda)*endo_0.X_o + I_o(t)^(param.xi) * param.G_o^(1-param.xi);
        F_o(t) = (1-endo_0.theta_o)* endo_0.F_o + param.lambda * X_o(t);
    else
        X_o(t) = (1-param.lambda)*X_o(t-1) + I_o(t)^(param.xi) * param.G_o^(1-param.xi);
        F_o(t) = (1-theta_o(t-1))* F_o(t-1) + param.lambda * X_o(t);
    end
end

theta_o_L   = [endo_0.theta_o; theta_o(1:end-1)]; % This is theta_t
F_o_L       = [endo_0.F_o; F_o(1:end-1)];
F_n_L       = [endo_0.F_n; F_n(1:end-1)];
F_f_L       = [endo_0.F_f; F_f(1:end-1)];

o           = theta_f.*F_f_L + theta_o_L.*F_o_L + theta_n_L.*F_n_L;
y           = (p./param.s_o).^(param.epsilon).*o;
va    = (1/(1-param.s_o) * ...
    (y.^((param.epsilon-1)/param.epsilon) ...
        - param.s_o.*o.^((param.epsilon-1)/param.epsilon))).^(param.epsilon/(param.epsilon-1));

l = (1/param.varphi * (1-param.alpha) * (1-param.s_o) * y.^(1/param.epsilon) .* va.^((param.epsilon-1)/param.epsilon)).^(1/(1+param.nu));
w = param.varphi * l.^param.nu;
k = (va .* (l.^(param.alpha-1))).^(1/param.alpha); % remember there's a single residual equation here (time 0)
resid_last = k(1) - endo_0.K;

r = param.alpha * (1-param.s_o) * y.^(1/param.epsilon) .* va.^((param.epsilon-1)/param.epsilon) .* k.^(-1);
r_p = [r(2:end); endo_T.r];

resid(:, 2) = 1 + r_p - param.delta - 1./beta_til_p;

k_p = [k(2:end); endo_T.K];

c = (1-param.delta)*k + y - k_p - I_o - I_n - I_f - param.psi * theta_n.^(param.eta) .*F_n_L - param.psi * theta_o.^(param.eta) .*F_o_L - param.psi_f * theta_f.^(param.eta_f) .*F_f_L;

c_T = (c(T-1)-param.varphi*l(T-1)^(1+param.nu)/(1+param.nu))*(beta_til_p(T-1)/param.beta)^(-1/param.gamma)+param.varphi * l(T)^(1+param.nu)/(1+param.nu);
c(end) = c_T;

resid(2:end-1, 3) = ((c(2:end-1)-param.varphi * l(2:end-1).^(1+param.nu)/(1+param.nu))./ ...
     (c(1:end-2)-param.varphi * l(1:end-2).^(1+param.nu)/(1+param.nu))).^(-param.gamma)*param.beta - beta_til_p(1:end-2);
resid(2:end-1, 3) = resid(2:end-1, 3)*5;


resid(1, 3)     = 5*resid_last; %10*
resid(end, 3)   =  endo_T.C-param.varphi * (endo_T.L).^(1+param.nu)/(1+param.nu) ...
    - (c(end)-param.varphi * l(end).^(1+param.nu)/(1+param.nu)).*((beta_til_p(end)/param.beta).^(-1/param.gamma));

resid(:, 3) = resid(:, 3);

phi_mu_1    = zeros(T, 1);
phi_mu_1_p  = [zeros(T-1, 1); endo_T.phis.mu_1];
phi_mu_2    = zeros(T, 1);
phi_mu_2_p  = [zeros(T-1, 1); endo_T.phis.mu_2];

for t = T:(-1):1
    
    phi_mu_1(t) = beta_til_p(t).*(theta_n(t).*phi_o_p(t) + (1-theta_n(t)).*phi_mu_1_p(t)-param.psi*(theta_n(t)^(param.eta))*phi_RC_p(t));
    phi_mu_2(t) = param.lambda * phi_mu_1(t) + beta_til_p(t) * (1-param.lambda)*phi_mu_2_p(t);
    if t>1
        phi_mu_1_p(t-1) = phi_mu_1(t);
        phi_mu_2_p(t-1) = phi_mu_2(t);
    end
end

phi_I = (param.xi * I_n.^(param.xi-1) * param.G_n^(1-param.xi) .* phi_mu_2 - phi_RC)./ ((1-param.xi)*param.xi * I_n.^(param.xi-2)*param.G_n^(1-param.xi).*mu_2_n);

phi_X = zeros(T, 1);
phi_F = zeros(T, 1);
phi_theta = zeros(T, 1);
for t = 1:T

    if t==1
        phi_X(t) = (1-param.lambda)*endo_0.phis.X + param.xi * I_n(t)^(param.xi-1) * param.G_n^(1-param.xi)*phi_I(t);
        phi_F(t) = param.lambda * phi_X(t) + (1-theta_n_L(t))*endo_0.phis.F-endo_0.phis.theta;            
    else
        phi_X(t) = (1-param.lambda)*phi_X(t-1) + param.xi * I_n(t)^(param.xi-1) * param.G_n^(1-param.xi)*phi_I(t);
        phi_F(t) = param.lambda * phi_X(t) + (1-theta_n_L(t))*phi_F(t-1)-phi_theta(t-1);   
    end
    
    phi_theta(t) = ((p_p(t) - mu_1_n_p(t)-param.psi*param.eta*(theta_n(t)^(param.eta-1)))*phi_F(t) ...
                        - param.eta*param.psi*theta_n(t)^(param.eta-1)*F_n(t)*phi_RC_p(t) ...
                        + F_n(t)*phi_o_p(t) - F_n(t)*phi_mu_1_p(t))/(param.eta*(param.eta-1)*param.psi*theta_n(t)^(param.eta-2));
    
end

phi_mu_1_f = zeros(T, 1);
phi_mu_2_f = zeros(T, 1);

for t = T:(-1):1
    if t==T
        phi_mu_1_f(t) = beta_til_p(t) * ((1-theta_f_p(t))*endo_T.phis.mu_1_f-param.psi_f*theta_f_p(t)^(param.eta_f)*phi_RC_p(t)+theta_f_p(t)*phi_o_p(t));
        phi_mu_2_f(t) = param.lambda_f * phi_mu_1_f(t) + beta_til_p(t) * (1-param.lambda_f) * endo_T.phis.mu_2_f;
    else
        phi_mu_1_f(t) = beta_til_p(t) * ((1-theta_f_p(t))*phi_mu_1_f(t+1)-param.psi_f*theta_f_p(t)^(param.eta_f)*phi_RC_p(t)+theta_f_p(t)*phi_o_p(t));       
        phi_mu_2_f(t) = param.lambda_f * phi_mu_1_f(t) + beta_til_p(t) * (1-param.lambda_f) * phi_mu_2_f(t+1);
    end
end

phi_I_f = (param.xi * I_f.^(param.xi-1) * param.G_f^(1-param.xi) .* zeta_f_TD .* phi_mu_2_f - phi_RC)...
        ./((1-param.xi)*param.xi*I_f.^(param.xi-2)*param.G_f^(1-param.xi) .* zeta_f_TD .*mu_2_f);
    
phi_X_f = zeros(T, 1);
for t = 1:T
    if t==1
        phi_X_f(t) = (1-param.lambda_f)*endo_0.phis.X_f + param.xi * I_f(t).^(param.xi-1) * param.G_f^(1-param.xi) * zeta_f_TD(t) * phi_I_f(t);
    else
        phi_X_f(t) = (1-param.lambda_f)*phi_X_f(t-1) + param.xi * I_f(t).^(param.xi-1) * param.G_f^(1-param.xi) * zeta_f_TD(t) * phi_I_f(t);
    end
end


phi_theta_f = (-F_f_L .* phi_mu_1_f - param.eta_f * param.psi_f * theta_f.^(param.eta_f-1).*F_f_L .* phi_RC + F_f_L.*phi_o)... 
            ./(param.eta_f * (param.eta_f-1) * param.psi_f * theta_f.^(param.eta_f-2));
        

phi_F_f = zeros(T,1);
for t = 1:T
    if t==1
        phi_F_f(t) = param.lambda_f * phi_X_f(t) + (1-theta_f(t))*endo_0.phis.F_f - phi_theta_f(t);
    else
        phi_F_f(t) = param.lambda_f * phi_X_f(t) + (1-theta_f(t))* phi_F_f(t-1) - phi_theta_f(t);
    end
end

phi_F_L = [endo_0.phis.F; phi_F(1:end-1)];
phi_theta_L = [endo_0.phis.theta; phi_theta(1:end-1)];
phi_F_f_L = [endo_0.phis.F_f; phi_F_f(1:end-1)];

phi_p = theta_o_L .* F_o_L - phi_theta_f - (theta_n_L.*phi_F_L + phi_theta_L + theta_f.*phi_F_f_L);

phi_y = 1./(y.^(1/param.epsilon)*param.s_o.*o.^(-1/param.epsilon)) .* (1/param.epsilon * param.s_o * y.^(1/param.epsilon).*o.^(-(1+param.epsilon)/param.epsilon).*phi_p - phi_o);

y_p     = [y(2:end); endo_T.Y];
phi_y_p = [phi_y(2:end); endo_T.phis.Y];

phi_r_p = (param.alpha * (param.epsilon-1) * y_p .*(phi_y_p+phi_RC_p) ...
    - (param.epsilon-1)/param.epsilon * param.alpha * p .*phi_p ...
    + k_p .* (r_p .*phi_y_p - (1-param.delta) * phi_RC_p + 1./beta_til_p.*phi_RC))./r_p;
phi_r = [endo_0.phis.r; phi_r_p(1:end-1)];

phi_w = 1./w .* (param.epsilon * y .* (phi_y + phi_RC) - p.*phi_p - r.*phi_r);
phi_l = param.nu * w ./ l .* phi_w;
phi_k = phi_r_p;
phi_k_L = phi_r;

phi_X_L = [endo_0.phis.X; phi_X(1:end-1)];
phi_X_f_L = [endo_0.phis.X_f; phi_X_f(1:end-1)];


phi_beta = 1/param.beta * ((param.eta * param.psi * theta_n_L.^(param.eta-1) + mu_1_n - p) .* phi_theta_L ...
            + (1+r-param.delta).*phi_k_L - (p.*theta_n_L + (1-theta_n_L) .*mu_1_n - param.psi *theta_n_L.^(param.eta)).*phi_F_L ...
            - (1-param.lambda)*mu_2_n .* phi_X_L - (p.*theta_f + (1-theta_f).*mu_1_f - param.psi_f * theta_f.^(param.eta_f)).*phi_F_f_L ...
            - (1-param.lambda_f)*mu_2_f.*phi_X_f_L);

phi_beta_p = [phi_beta(2:end); endo_T.phis.beta];        

resid(:, 4) = param.gamma * param.beta * (c-param.varphi * l.^(1+param.nu)/(1+param.nu)).^(-1) .* (phi_beta - beta_til_p.* phi_beta_p)...
    - phi_RC + param.gamma * (c-param.varphi * l.^(1+param.nu)/(1+param.nu)).^(-1) .* (theta_o_L .*F_o_L.*p - I_o - param.psi * theta_o_L.^param.eta .*F_o_L);

resid(:, 5) = param.varphi * l.^(param.nu) .*phi_RC + (param.epsilon-1)/param.epsilon * (1-param.alpha) * r .* l.^(-1) .* phi_r + w.*phi_y ...
    - (1-(param.epsilon-1)/param.epsilon*(1-param.alpha))*w.* l.^(-1).*phi_w - phi_l;


TD_names = {'mu_1_n', 'mu_2_n', 'beta_til_p', 'I_n', 'X_n', 'F_n', 'mu_1_f', 'mu_2_f', 'I_f', 'X_f', 'F_f', 'mu_1_o', 'mu_2_o', ...
            'phi_o', 'I_o', 'X_o', 'F_o', 'o', 'y', 'va', 'l', 'w', 'k_p', 'r', 'c', 'phi_mu_1', 'phi_mu_2', 'phi_I', 'phi_X', ...
            'phi_F', 'phi_theta', 'phi_mu_1_f', 'phi_mu_2_f', 'phi_I_f', 'phi_X_f', 'phi_theta_f', 'phi_F_f', 'phi_p', 'phi_y', ...
            'phi_r', 'phi_w', 'phi_l', 'phi_k', 'phi_beta', 'theta_o', 'theta_n', 'theta_f', 'p', 'phi_RC'};

TD_ = struct;        
for i = 1:length(TD_names)
    eval(['TD_.' TD_names{i} ' = ' TD_names{i} ';']);
end

resid = (resid(:));

if ~isreal(resid)
    error('Residuals not real')
end

